﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// An explosion. Could be used as a damaging bullet or an effect.
    /// </summary>
    class Explosion : Bullet
    {
        #region Member Variables

        /// <summary>
        /// The entity's texture.
        /// </summary>
        static Texture2D _texture;

        #endregion

        #region Properties

        public override Rectangle Hitbox
        {
            get { return new Rectangle((int)_position.X, (int)_position.Y, 8, 7); }
        }

        #endregion

        /// <summary>
        /// Creates a new harmful explosion.
        /// </summary>
        /// <param name="room">The reference to the current room.</param>
        /// <param name="position">The position to create the explosion.</param>
        /// <param name="bulletOwner">The entity that created the explosion.</param>
        /// <param name="damage">How much damage the bullet should deal.</param>
        /// <param name="speed">The bullet's speed vector.</param>
        /// <param name="destroyOnCollision">Whether or not the bullet should be destroyed
        /// when a collision is encountered.</param>
        public Explosion(Room room, Vector2 position, Entity bulletOwner, int damage,
            Vector2 speed, bool destroyOnCollision)
            : base(room, position, bulletOwner, damage, speed, destroyOnCollision, true)
        {
        }

        #region Methods

        /// <summary>
        /// Create all animations associated with this bullet.
        /// </summary>
        protected override void InitialiseAnimations()
        {
            //The only animation.
            _animation = new Animation(new Tuple<Rectangle, Vector2, int>
                (new Rectangle(0, 4, 24, 24), new Vector2(-12, -12), 2), 0);
            _animation.AddFrame(new Tuple<Rectangle, Vector2, int>
                (new Rectangle(24, 2, 28, 28), new Vector2(-14, -14), 2));
            _animation.AddFrame(new Tuple<Rectangle, Vector2, int>
                (new Rectangle(52, 1, 30, 30), new Vector2(-15, -15), 2));
            _animation.AddFrame(new Tuple<Rectangle, Vector2, int>
                (new Rectangle(82, 0, 32, 32), new Vector2(-16, -16), 2));
            _animation.AddFrame(new Tuple<Rectangle, Vector2, int>
                (new Rectangle(114, 1, 30, 30), new Vector2(-15, -15), 2));
            _animation.AddFrame(new Tuple<Rectangle, Vector2, int>
                (new Rectangle(144, 0, 32, 32), new Vector2(-16, -16), 2));
            _animation.AddFrame(new Tuple<Rectangle, Vector2, int>
                (new Rectangle(), Vector2.Zero, 0));
        }

        /// <summary>
        /// Load all assests asscociated with this entity.
        /// </summary>
        /// <param name="content">The content manager to load to.</param>
        public static void LoadContent(ContentManager content)
        {
            //Load in a default texture.
            _texture = content.Load<Texture2D>("Images\\Explosion");
        }

        /// <summary>
        /// Performs
        /// </summary>
        /// <param name="gameTime"></param>
        public override void Update(GameTime gameTime)
        {
            //Update frames.
            _animation.Update();
        }

        /// <summary>
        /// Draw the bullet to the screen.
        /// </summary>
        /// <param name="spriteBatch">The sprite batch to draw to.</param>
        public override void Draw(SpriteBatch spriteBatch)
        {
            //Get the necessary details from the current animation frame.
            Rectangle currentFrameSource = _animation.CurrentFrame.Item1;
            Vector2 currentFrameOffset = _animation.CurrentFrame.Item2;

            spriteBatch.Draw(_texture,
                                _position + new Vector2(currentFrameOffset.X, currentFrameOffset.Y),
                                currentFrameSource,
                                Color.White);
        }

        #endregion
    }
}
