﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// An instance of a Quick Man laser. These fly across the screen and instantly kill
    /// any Mega Mans who touch it. They are created by Quick Man laser generators.
    /// </summary>
    class QuickManLaser : Bullet
    {
        #region Member Variables

        /// <summary>
        /// The texture of Quick Man lasers.
        /// </summary>
        static Texture2D _texture;

        /// <summary>
        /// The original position of the laser.
        /// </summary>
        Vector2 _startPosition;

        #endregion

        #region Properties

        /// <summary>
        /// Returns the laser's hitbox.
        /// </summary>
        public override Rectangle Hitbox
        {
            get
            {
                //Calculate the stretched hitbox, dependent on the direction of the laser.
                if (_position.X > _startPosition.X)
                    return new Rectangle((int)_startPosition.X, (int)_position.Y,
                        (int)(_position.X - _startPosition.X), 16);
                else
                    return new Rectangle((int)_position.X, (int)_position.Y,
                        (int)(_startPosition.X - _position.X), 16);
            }
        }

        #endregion

        /// <summary>
        /// Creates a new Quick Man laser.
        /// </summary>
        /// <param name="room">The current room.</param>
        /// <param name="position">The original position of the laser.</param>
        /// <param name="bulletOwner">The entity that created this laser.</param>
        /// <param name="damage">The amount of damage this laser deals.</param>
        /// <param name="speed">The speed of the laser.</param>
        public QuickManLaser(Room room, Vector2 position, Entity bulletOwner, int damage,
            Vector2 speed)
            : base(room, position, bulletOwner, damage, speed, false, false)
        {
            _startPosition = position;
        }

        #region Methods

        /// <summary>
        /// Loads the assets required by Quick Man lasers.
        /// </summary>
        /// <param name="content">The game's content manager.</param>
        public static void LoadContent(ContentManager content)
        {
            _texture = content.Load<Texture2D>("Images\\Laser");
        }

        /// <summary>
        /// Updates the Quick Man laser.
        /// </summary>
        /// <param name="gameTime">The current snapshot of time.</param>
        public override void Update(GameTime gameTime)
        {
            base.Update(gameTime);
        }

        /// <summary>
        /// Draws the Quick Man laser to the screen.
        /// </summary>
        /// <param name="spriteBatch">The sprite batch to draw to</param>
        public override void Draw(SpriteBatch spriteBatch)
        {
            //Rainbow drawing stuff.
            Rectangle sourceRectangle;

            if (_position.X < _startPosition.X)
                sourceRectangle = new Rectangle((int)_position.X, 0, Hitbox.Width, Hitbox.Height);
            else
                sourceRectangle = new Rectangle(0, 0, Hitbox.Width, Hitbox.Height);

            //Draw the repeated texture.
            spriteBatch.Draw(_texture, Hitbox, sourceRectangle, Color.White);
        }

        #endregion
    }
}
