﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MegaManRipoff.MainGameClasses
{
    public class BossDestroyEventArgs : EventArgs
    {
        /// <summary>
        /// The amount of time to wait, in ticks, before the level ends.
        /// </summary>
        public int WaitingTime { get; private set; }

        public BossDestroyEventArgs(int waitingTime)
        {
            WaitingTime = waitingTime;
        }
    }

    /// <summary>
    /// Signature for the event called when the boss has been destroyed.
    /// </summary>
    /// <param name="sender">The sender object.</param>
    /// <param name="e">Event arguments.</param>
    public delegate void BossDestroy(object sender, BossDestroyEventArgs e);

    /// <summary>
    /// Defines a boss that will cause the level to be won when
    /// it has been destroyed.
    /// </summary>
    interface IBoss
    {
        /// <summary>
        /// The event called when the boss is destroyed.
        /// </summary>
        event BossDestroy OnBossDestroy;
    }
}
