﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// Defines an entity that has health.
    /// </summary>
    abstract class HealthyEntity : Entity
    {
        #region Properties

        /// <summary>
        /// When overriden in an inheriting class, gets the current
        /// health of the entity.
        /// </summary>
        abstract public int Health { get; set; }

        /// <summary>
        /// When overriden in an inheriting class, gets the maximum
        /// possible health of the entity.
        /// </summary>
        abstract public int MaxHealth { get; }

        #endregion

        /// <summary>
        /// Creates an entity at the given position in the given room.
        /// </summary>
        /// <param name="room">The current room.</param>
        /// <param name="position">The position of the entity in the room.</param>
        public HealthyEntity(Room room, Vector2 position)
            : base(room, position)
        {
        }

        #region Methods

        /// <summary>
        /// When overriden in an inheriting class, deals damage to the entity.
        /// </summary>
        /// <param name="damage">The amount of damage to be dealt.</param>
        abstract protected void GetHurt(int damage);

        /// <summary>
        /// When overriden in an inheriting class, kills the entity. :(
        /// </summary>
        abstract protected void Die();
        
        #endregion
    }
}
