﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// A slice of cake. If the player touches this, the game abruptly ends as this is
    /// a requirement of the assessment.
    /// </summary>
    class Cake : Item
    {
        /// <summary>
        /// The cake's texture.
        /// </summary>
        static Texture2D _texture;

        /// <summary>
        /// Gets the cake's hitbox.
        /// </summary>
        public override Rectangle Hitbox
        {
            get { return new Rectangle((int)_position.X, (int)_position.Y, 24, 24); }
        }

        /// <summary>
        /// Creates a new cake.
        /// </summary>
        /// <param name="room">The current room.</param>
        /// <param name="position">The position of the cake.</param>
        public Cake(Room room, Vector2 position)
            : base(room, position, false)
        {
        }

        #region Methods

        /// <summary>
        /// This method exists so that a NotImplementedException isn't thrown.
        /// </summary>
        protected override void InitialiseAnimations()
        {
            //Do nothing - the dark area doesn't have animations.
        }

        /// <summary>
        /// Loads the assets required by the game finisher.
        /// </summary>
        /// <param name="content">The game's content manager.</param>
        new public static void LoadContent(ContentManager content)
        {
            _texture = content.Load<Texture2D>("Images\\Cake");
        }

        /// <summary>
        /// Updates the cake.
        /// </summary>
        /// <param name="gameTime">The current snapshot of time.</param>
        public override void Update(GameTime gameTime)
        {
            base.Update(gameTime);
        }

        /// <summary>
        /// Draws the cake to the screen.
        /// </summary>
        /// <param name="spriteBatch">The sprite batch to be drawn to.</param>
        public override void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.Draw(_texture, _position, Color.White);
        }

        #endregion
    }
}
