﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// Defines methods that allow a heads up display component
    /// to be drawn to the screen.
    /// </summary>
    interface IHudComponent
    {
        Vector2 Position { get; }

        /// <summary>
        /// Draws the component to the screen.
        /// </summary>
        /// <param name="spriteBatch">The sprite batch to draw to.</param>
        void Draw(SpriteBatch spriteBatch);
    }
}
