﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// Displays the number of lives that the player has.
    /// </summary>
    class LivesCounter : IHudComponent
    {
        #region Member Variables

        /// <summary>
        /// The position of the lives counter on the HUD.
        /// </summary>
        Vector2 _position;

        /// <summary>
        /// The texture used to display the life icon.
        /// </summary>
        static Texture2D _texture;

        /// <summary>
        /// The font used to display the number of lives.
        /// </summary>
        static SpriteFont _font;

        #endregion

        #region Properties

        /// <summary>
        /// The lives counter's position on the HUD.
        /// </summary>
        public Vector2 Position
        {
            get { return _position; }
        }

        #endregion

        /// <summary>
        /// Creates a lives counter on the HUD.
        /// </summary>
        /// <param name="position">The position of the lives counter on the HUD.</param>
        public LivesCounter(Vector2 position)
        {
            _position = position;
        }

        #region Methods

        /// <summary>
        /// Loads the assets required by the lives counter.
        /// </summary>
        /// <param name="content">The game's content manager.</param>
        public static void LoadContent(ContentManager content)
        {
            _texture = content.Load<Texture2D>("Images\\ExtraLife");
            _font = content.Load<SpriteFont>("Fonts\\SegoeUISmall");
        }

        /// <summary>
        /// Draws the lives counter to the screen.
        /// </summary>
        /// <param name="spriteBatch">The sprite batch to draw to.</param>
        public void Draw(SpriteBatch spriteBatch)
        {
            //Draw the life icon.
            spriteBatch.Draw(_texture,
                             _position,
                             new Rectangle(0, 0, 16, 16),
                             Color.White);

            //Draw the number of lives shadow.
            spriteBatch.DrawString(_font,
                                   " x " + Player.Lives,
                                   _position + new Vector2(17, -4),
                                   Color.Black);

            //Draw the number of lives.
            spriteBatch.DrawString(_font,
                                   " x " + Player.Lives,
                                   _position + new Vector2(16, -5),
                                   Color.White);
        }

        #endregion
    }
}
