﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using MegaManRipoff.UI;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// Handles creating the pause screen.
    /// </summary>
    class PauseScreen
    {
        #region Member Variables

        /// <summary>
        /// The font used for the menu's list items.
        /// </summary>
        static SpriteFont _font;

        /// <summary>
        /// The texture used for the menu cursor.
        /// </summary>
        static Texture2D _cursor;

        /// <summary>
        /// The menu used for the pause screen.
        /// </summary>
        Menu _menu;

        #endregion

        #region Properties

        /// <summary>
        /// The menu used by this pause screen.
        /// </summary>
        public Menu Menu
        {
            get { return _menu; }
        }

        #endregion

        /// <summary>
        /// Creates a new pause screen.
        /// </summary>
        public PauseScreen()
        {
            //Create the menu.
            _menu = new Menu(_font, _cursor, new Vector2(-32, 16), true);
        }

        #region Methods

        /// <summary>
        /// Loads the assets required by the pause screen.
        /// </summary>
        /// <param name="content">The game's content manager.</param>
        public static void LoadContent(ContentManager content)
        {
            _font = content.Load<SpriteFont>("Fonts\\SegoeUI");
            _cursor = content.Load<Texture2D>("Images\\Cursor");
        }

        /// <summary>
        /// Updates the pause screen.
        /// </summary>
        /// <param name="gameTime">The current snapshot of time.</param>
        public void Update(GameTime gameTime)
        {
            _menu.Update(gameTime);
        }

        /// <summary>
        /// Draws the pause screen.
        /// </summary>
        /// <param name="spriteBatch">The sprite batch to draw to.</param>
        public void Draw(SpriteBatch spriteBatch)
        {
            //Dim the screen slightly.
            Texture2D dimmer = new Texture2D(spriteBatch.GraphicsDevice, 1, 1);
            dimmer.SetData(new Color[] { new Color(new Vector4(0.015f, 0, 0.04f, 0.3f)) });
            spriteBatch.Draw(dimmer,
                             new Rectangle(0, 0, Camera.VIEWPORT_WIDTH, Camera.VIEWPORT_HEIGHT),
                             Color.White);

            //Draw the menu.
            _menu.Draw(spriteBatch);
        }

        #endregion
    }
}
