﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// Displays informative text on the HUD.
    /// </summary>
    class TextDisplay : IHudComponent
    {
        #region Member Variables

        /// <summary>
        /// The text to display.
        /// </summary>
        string _text;

        /// <summary>
        /// The position of the health bar on the HUD.
        /// </summary>
        Vector2 _position;

        /// <summary>
        /// The font used to display information.
        /// </summary>
        static SpriteFont _font;

        /// <summary>
        /// The colour of the text.
        /// </summary>
        Color _textColour;

        /// <summary>
        /// The colour of the text's shadow.
        /// </summary>
        Color _shadowColour;

        #endregion

        #region Properties

        /// <summary>
        /// Gets the position of the text display.
        /// </summary>
        public Vector2 Position
        {
            get { return _position; }
        }

        /// <summary>
        /// Gets or sets the text to display.
        /// </summary>
        public string Text
        {
            get { return _text; }
            set { _text = value; }
        }

        #endregion

        #region Constructors

        /// <summary>
        /// Creates text on the HUD.
        /// </summary>
        /// <param name="text">The text to display.</param>
        /// <param name="position">The position of the text on the HUD.</param>
        /// <param name="textColour">The colour of the text.</param>
        /// <param name="shadowColour">The colour of the text's shadow.</param>
        public TextDisplay(string text, Vector2 position, Color textColour, Color shadowColour)
        {
            _text = text;
            _position = position;
            _textColour = textColour;
            _shadowColour = shadowColour;
        }

        /// <summary>
        /// Creates text on the HUD.
        /// </summary>
        /// <param name="text">The text to display.</param>
        /// <param name="position">The position of the text on the HUD.</param>
        public TextDisplay(string text, Vector2 position)
            : this(text, position, Color.White, Color.Black)
        {
        }

        #endregion

        #region Methods

        /// <summary>
        /// Loads the assets required by the text display.
        /// </summary>
        /// <param name="content"></param>
        public static void LoadContent(ContentManager content)
        {
            _font = content.Load<SpriteFont>("Fonts\\Calibri");
        }

        /// <summary>
        /// Draws the text to the HUD.
        /// </summary>
        /// <param name="spriteBatch">The sprite batch to draw to.</param>
        public void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.DrawString(_font, _text, _position + Vector2.One, _shadowColour);
            spriteBatch.DrawString(_font, _text, _position, _textColour);
        }

        #endregion
    }
}
