﻿/*using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

namespace MegaManRipoff
{
    /// <summary>
    /// A single raindrop, used by the RainCreator class
    /// to display rain.
    /// </summary>
    class RainDrop : Entity
    {
        #region Member Variables

        /// <summary>
        /// The texture for raindrops.
        /// </summary>
        static Texture2D _texture;

        /// <summary>
        /// The raindrop's animation.
        /// </summary>
        Animation _animation;

        /// <summary>
        /// The RainCreator instance that this raindrop belongs to.
        /// </summary>
        RainCreator _rainCreator;

        /// <summary>
        /// The direction that this raindrop is facing, in radians.
        /// </summary>
        float _direction;

        /// <summary>
        /// The speed at which this raindrop moves.
        /// </summary>
        new float _speed;

        #endregion

        /// <summary>
        /// Creates a new raindrop.
        /// </summary>
        /// <param name="room">The current room.</param>
        /// <param name="position">The position of the new raindrop.</param>
        /// <param name="rainCreator">The instance of RainCreator that this raindrop
        /// belongs to.</param>
        /// <param name="direction">The direction of movement, in radians.</param>
        public RainDrop(Room room, Vector2 position, RainCreator rainCreator, float direction, float speed)
            : base(room, position)
        {
            _rainCreator = rainCreator;
            _direction = direction;
            _speed = speed;
        }

        #region Methods

        /// <summary>
        /// Create all animations associated with this entity.
        /// </summary>
        protected override void InitialiseAnimations()
        {
            //The only frame.
            _animation = new Animation(new Tuple<Rectangle, Vector2, int>
                (new Rectangle(0, 0, 48, 5), Vector2.Zero, 0), 0);
        }

        /// <summary>
        /// Load the texture for the raindrop.
        /// </summary>
        /// <param name="content">The game's content manager.</param>
        new public static void LoadContent(ContentManager content)
        {
            _texture = content.Load<Texture2D>("Images\\RainDrop");
        }

        /// <summary>
        /// Updates the raindrop.
        /// </summary>
        /// <param name="gameTime">The current snapshot of time.</param>
        public override void Update(GameTime gameTime)
        {
            //Move the raindrop.
            _position += EntityHelper.RadialToVector(_speed, _direction);

            //If we're now outside the screen, destroy this raindrop.
            if (_position.Y - 48 > _room.CameraArea.Bottom)
            {
                //Destroy.
            }
        }

        /// <summary>
        /// Draws the raindrop.
        /// </summary>
        /// <param name="spriteBatch">The sprite batch to draw to.</param>
        public override void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.Draw(_texture,
                             _position,
                             _animation.CurrentFrame.Item1,
                             new Color(1f, 1f, 1f, _rainCreator.CurrentAlpha / RainCreator.MaximumAlpha),
                             _direction,
                             new Vector2(_animation.CurrentFrame.Item1.Center.X,
                                         _animation.CurrentFrame.Item1.Center.Y),
                             1,
                             SpriteEffects.None,
                             0.01f);
        }

        #endregion
    }
}*/
