﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// A tile that cannot be collided with - it is only used for decoration.
    /// </summary>
    class BackgroundTile : Tile
    {
        /// <summary>
        /// Creates a new background tile.
        /// </summary>
        /// <param name="position">The position to create the tile.</param>
        /// <param name="textureOrigin">The origin of the tile's graphic
        /// in the tileset.</param>
        public BackgroundTile(Vector2 position, Point textureOrigin)
            : base(position, textureOrigin)
        {
            _isSolid = false;
        }
    }
}
