﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// A slippery, collidable tile that has reduced friction.
    /// </summary>
    class IceTile : Tile
    {
        /// <summary>
        /// Creates a new ice tile with a given hitbox.
        /// </summary>
        /// <param name="position">The position to create the tile.</param>
        /// <param name="textureOrigin">The origin of the tile's graphic
        /// in the tileset.</param>
        /// <param name="hitbox">The tile's hitbox, relative to its position.</param>
        public IceTile(Vector2 position, Point textureOrigin, Rectangle hitbox)
            : base(position, textureOrigin, hitbox)
        {
            _friction = 0.05f;
            _isSolid = true;
        }
    }
}
