﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;

namespace MegaManRipoff.MainGameClasses
{
    /// <summary>
    /// A solid tile that entities can collide with. This is the most common
    /// type of tile.
    /// </summary>
    class SolidTile : Tile
    {
        /// <summary>
        /// Creates a new solid tile with a given hitbox.
        /// </summary>
        /// <param name="position">The position to create the tile.</param>
        /// <param name="textureOrigin">The origin of the tile's graphic
        /// in the tileset.</param>
        /// <param name="hitbox">The tile's hitbox, relative to its position.</param>
        public SolidTile(Vector2 position, Point textureOrigin, Rectangle hitbox)
            : base(position, textureOrigin, hitbox)
        {
            _friction = Tile.DEFAULT_FRICTION;
            _isSolid = true;
        }
    }
}
