﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;

namespace MegaManRipoff.UI
{
    /// <summary>
    /// The handler for the event called when the user has selected this item on the menu.
    /// </summary>
    /// <param name="sender">The object calling the event.</param>
    /// <param name="e">Event arguments.</param>
    public delegate void Selected(object sender, EventArgs e);

    /// <summary>
    /// Models an item on a menu.
    /// </summary>
    class MenuItem
    {
        #region Member Variables

        /// <summary>
        /// The menu that this menu item belongs to.
        /// </summary>
        Menu _menu;

        #endregion

        #region Properties

        /// <summary>
        /// The text that this menu item displays.
        /// </summary>
        public string Text { get; set; }

        /// <summary>
        /// The position of the menu item relative to the pause screen.
        /// </summary>
        public Vector2 Position { get; private set; }

        /// <summary>
        /// The amount of time the menu wait after this item is selected.
        /// </summary>
        public int Delay { get; private set; }

        #endregion

        /// <summary>
        /// The event called when this item in the menu is selected.
        /// </summary>
        public event Selected OnSelected;

        #region Constructors

        /// <summary>
        /// Creates a new menu item.
        /// </summary>
        /// <param name="menu">The menu that this menu item belongs to.</param>
        /// <param name="text">The text that this menu item displays.</param>
        /// <param name="position">The position of the menu item relative to the pause screen.</param>
        public MenuItem(Menu menu, string text, Vector2 position)
        {
            _menu = menu;
            Text = text;
            Position = position;
        }

        /// <summary>
        /// Creates a new menu item.
        /// </summary>
        /// <param name="menu">The menu that this menu item belongs to.</param>
        /// <param name="text">The text that this menu item displays.</param>
        /// <param name="position">The position of the menu item relative to the pause screen.</param>
        /// <param name="delay">The amount of time the menu wait after this item is selected.</param>
        public MenuItem(Menu menu, string text, Vector2 position, int delay)
            : this(menu, text, position)
        {
            Delay = delay;
        }

        #endregion

        /// <summary>
        /// Activates this menu item's selection event.
        /// </summary>
        public void Select()
        {
            if (OnSelected != null)
                OnSelected(this, new EventArgs());
        }
    }
}
