﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using TrackmaniaServerTool.Properties;

namespace TrackmaniaServerTool
{
	public partial class CopyFromMyMaps : Form
	{
		string LocalMapsRootFolderPath;
		string ServerMapsRootFolderPath;

		public CopyFromMyMaps(string serverMapsRootFolderPath)
		{
			InitializeComponent();

			ServerMapsRootFolderPath = serverMapsRootFolderPath;

			LocalMapsRootFolderPath = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), "Trackmania\\Maps\\");
			if (Directory.Exists(LocalMapsRootFolderPath))
			{
				mapsRootFolderTextBox.Text = LocalMapsRootFolderPath;
			}
			else
			{
				FolderBrowserDialog2 folderBrowserDialog2 = new FolderBrowserDialog2();
				folderBrowserDialog2.DirectoryPath = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
				folderBrowserDialog2.ShowDialog(this);
				mapsRootFolderTextBox.Text = LocalMapsRootFolderPath = folderBrowserDialog2.DirectoryPath;
			}

			foreach (string str in Settings.Default.CopyFromMapsFolderExclusions)
			{
				exclusionsListBox.Items.Add(str);
			}
		}

		private void addExclusionButton_Click(object sender, EventArgs e)
		{
			FolderBrowserDialog2 folderBrowserDialog2 = new FolderBrowserDialog2();
			folderBrowserDialog2.DirectoryPath = LocalMapsRootFolderPath;
			if (folderBrowserDialog2.ShowDialog(this) == DialogResult.OK)
			{
				string relativePath = Utilities.GetRelativePath(folderBrowserDialog2.DirectoryPath, LocalMapsRootFolderPath, true);
				if (!exclusionsListBox.Items.Contains(relativePath))
				{
					exclusionsListBox.Items.Add(relativePath);
					Settings.Default.CopyFromMapsFolderExclusions.Add(relativePath);
					Settings.Default.Save();
				}
			}
		}

		private void removeExclusionButton_Click(object sender, EventArgs e)
		{
			object[] selectedItemsCopy = new object[exclusionsListBox.SelectedItems.Count];
			exclusionsListBox.SelectedItems.CopyTo(selectedItemsCopy, 0);
			foreach (object item in selectedItemsCopy)
			{
				string str = item as string;
				if (str == null)
					continue;

				exclusionsListBox.Items.Remove(str);
				Settings.Default.CopyFromMapsFolderExclusions.Remove(str);
			}

			Settings.Default.Save();
		}

		private void copyButton_Click(object sender, EventArgs e)
		{
			int copiedFilesCount = 0;
			string errorString = "";

			foreach (string originDirectory in Directory.EnumerateDirectories(LocalMapsRootFolderPath, "*", SearchOption.AllDirectories))
			{
				if (IsExcludedDirectory(originDirectory))
					continue;

				string relativeDirectory = Utilities.GetRelativePath(originDirectory, LocalMapsRootFolderPath, true);
				string targetDirectory = Path.Combine(ServerMapsRootFolderPath, relativeDirectory);

				foreach (string originFile in Directory.EnumerateFiles(originDirectory, "*.Map.Gbx", SearchOption.TopDirectoryOnly))
				{
					if (!Directory.Exists(targetDirectory))
					{
						Directory.CreateDirectory(targetDirectory);
					}

					string relativeFile = Utilities.GetRelativePath(originFile, LocalMapsRootFolderPath, true);
					string targetFile = Path.Combine(ServerMapsRootFolderPath, relativeFile);

					try
					{
						if (!File.Exists(targetFile) || (overwriteCheckBox.Checked && File.GetLastWriteTime(originFile) > File.GetLastWriteTime(targetFile)))
						{
							File.Copy(originFile, targetFile, overwriteCheckBox.Checked);
							File.SetCreationTime(targetFile, File.GetCreationTime(originFile));
							File.SetLastWriteTime(targetFile, File.GetLastWriteTime(originFile));
							++copiedFilesCount;
						}
					}
					catch (Exception ex)
					{
						errorString += ex.Message.ToString() + "\r\n";
					}
				}
			}

			if (errorString.Length > 0)
			{
				MessageBox.Show(this, "Copied " + copiedFilesCount + " files with errors:\r\n" + errorString, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
			else
			{
				MessageBox.Show(this, "Copied " + copiedFilesCount + " files.", "", MessageBoxButtons.OK, MessageBoxIcon.Information);
			}

			DialogResult = DialogResult.OK;
			Close();
		}

		private void cancelButton_Click(object sender, EventArgs e)
		{
			DialogResult = DialogResult.Cancel;
			Close();
		}

		bool IsExcludedDirectory(string path)
		{
			foreach (string str in Settings.Default.CopyFromMapsFolderExclusions)
			{
				string excludedPath = Path.Combine(LocalMapsRootFolderPath, str);
				if (path == excludedPath)
					return true;
			}

			return false;
		}
	}
}
