﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrackmaniaServerTool
{
	public class Tracklist
	{
		public Tracklist(string[] maps = null, int startIndex = 0, int gameMode = 0, string scriptName = "Trackmania/TM_TimeAttack_Online")
		{
			Maps = maps;
			StartIndex = startIndex;
			GameMode = gameMode;
			ScriptName = scriptName;
		}

		public string[] Maps { get; set; }
		public int StartIndex { get; set; }
		public int GameMode { get; set; }
		public string ScriptName { get; set; }

		public override bool Equals(object obj)
		{
			Tracklist other = (Tracklist)obj;
			if (other == null)
				return false;

			bool areMapsEqual;
			if (Maps != null && other.Maps != null)
			{
				areMapsEqual = Enumerable.SequenceEqual(Maps, other.Maps);
			}
			else if (Maps != null && other.Maps == null)
			{
				areMapsEqual = (Maps.Length == 0);
			}
			else if (Maps == null && other.Maps != null)
			{
				areMapsEqual = (other.Maps.Length == 0);
			}
			else
			{
				areMapsEqual = true;
			}

			bool areScriptNamesEqual;
			if (ScriptName != null && other.ScriptName != null)
			{
				areScriptNamesEqual = ScriptName.Equals(other.ScriptName);
			}
			else
			{
				areScriptNamesEqual = (ScriptName == null && other.ScriptName == null);
			}

			return areMapsEqual && areScriptNamesEqual && StartIndex.Equals(other.StartIndex) && GameMode.Equals(other.GameMode);
		}

		public override int GetHashCode()
		{
			return base.GetHashCode();
		}
	}
}
