﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml;

namespace TrackmaniaServerTool
{
	static class TracklistFileHandler
	{
		public static Tracklist Open(string filename)
		{
			Tracklist tracklist = new Tracklist();
			List<string> maps = new List<string>();

			try
			{
				XmlReaderSettings xmlReaderSettings = new XmlReaderSettings();
				xmlReaderSettings.CloseInput = true;
				xmlReaderSettings.IgnoreComments = true;
				xmlReaderSettings.IgnoreWhitespace = true;

				using (XmlReader xmlReader = XmlReader.Create(filename, xmlReaderSettings))
				{
					xmlReader.MoveToContent();
					while (xmlReader.Read())
					{
						if (xmlReader.NodeType != XmlNodeType.Element)
							continue;

						switch (xmlReader.Name)
						{
						case "game_mode":
							tracklist.GameMode = xmlReader.ReadElementContentAsInt();
							break;

						case "script_name":
							tracklist.ScriptName = xmlReader.ReadElementContentAsString();
							break;

						case "startindex":
							tracklist.StartIndex = xmlReader.ReadElementContentAsInt();
							break;

						case "file":
							maps.Add(xmlReader.ReadElementContentAsString());
							break;
						}
					}

					xmlReader.Close();
				}
			}
			catch (FileNotFoundException)
			{
			}
			catch (Exception e)
			{
				MessageBox.Show("Could not open tracklist: " + e.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}

			tracklist.Maps = maps.ToArray();
			return tracklist;
		}

		public static bool Save(string filename, Tracklist tracklist)
		{
			try
			{
				XmlWriterSettings xmlWriterSettings = new XmlWriterSettings();
				xmlWriterSettings.CloseOutput = true;
				xmlWriterSettings.Encoding = Encoding.UTF8;
				xmlWriterSettings.Indent = true;
				xmlWriterSettings.IndentChars = "\t";
				xmlWriterSettings.NewLineChars = "\n";

				using (XmlWriter xmlWriter = XmlWriter.Create(filename, xmlWriterSettings))
				{
					xmlWriter.WriteStartDocument();
					xmlWriter.WriteStartElement("playlist");

					xmlWriter.WriteStartElement("gameinfos");
					{
						xmlWriter.WriteStartElement("game_mode");
						xmlWriter.WriteString(tracklist.GameMode.ToString());
						xmlWriter.WriteEndElement();

						xmlWriter.WriteStartElement("script_name");
						xmlWriter.WriteString(tracklist.ScriptName);
						xmlWriter.WriteEndElement();
					}
					xmlWriter.WriteEndElement();

					xmlWriter.WriteStartElement("startindex");
					xmlWriter.WriteString(tracklist.StartIndex.ToString());
					xmlWriter.WriteEndElement();

					foreach (string map in tracklist.Maps)
					{
						xmlWriter.WriteStartElement("map");
						xmlWriter.WriteStartElement("file");
						xmlWriter.WriteString(map);
						xmlWriter.WriteEndElement();
						xmlWriter.WriteEndElement();
					}

					xmlWriter.WriteEndDocument();
					xmlWriter.Close();
				}
			}
			catch (Exception e)
			{
				MessageBox.Show("Could not save tracklist: " + e.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return false;
			}

			return true;
		}
	}
}
