﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrackmaniaServerTool
{
	static class Utilities
	{
		public static string GetRelativePath(string fullPath, string basePath, bool useBackslashes = false)
		{
			if (basePath.Length == 0)
				return fullPath;

			Uri fullUri = new Uri(fullPath);
			Uri baseUri = new Uri(basePath);
			Uri relativeUri = baseUri.MakeRelativeUri(fullUri);

			string relativeString = Uri.UnescapeDataString(relativeUri.ToString());
			if (useBackslashes)
			{
				relativeString = relativeString.Replace('/', '\\');
			}

			return relativeString;
		}
	}
}
